/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4614;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.gates.GateManager;
import ram.talia.hexal.common.lib.hex.HexalIotaTypes;

public class GateIota
extends Iota {
    public static String TAG_INDEX = "index";
    public static String TAG_TARGET_TYPE = "target_type";
    public static String TAG_TARGET_X = "target_x";
    public static String TAG_TARGET_Y = "target_y";
    public static String TAG_TARGET_Z = "target_z";
    public static String TAG_TARGET_UUID = "target_uuid";
    public static String TAG_TARGET_NAME = "target_name";
    public static IotaType<GateIota> TYPE = new IotaType<GateIota>(){

        private GateIota deserialize(class_2520 tag) throws IllegalArgumentException {
            if (tag.method_23258() == class_2497.field_21037) {
                class_2497 itag = (class_2497)tag;
                return new GateIota(itag.method_10701(), null);
            }
            class_2487 ctag = (class_2487)HexUtils.downcast((class_2520)tag, (class_4614)class_2487.field_21029);
            int index = ctag.method_10550(TAG_INDEX);
            byte type2 = ctag.method_10571(TAG_TARGET_TYPE);
            if (type2 == 0) {
                return new GateIota(index, null);
            }
            double x = ctag.method_10574(TAG_TARGET_X);
            double y = ctag.method_10574(TAG_TARGET_Y);
            double z = ctag.method_10574(TAG_TARGET_Z);
            class_243 vec = new class_243(x, y, z);
            if (type2 == 1) {
                return new GateIota(index, (Either<class_243, Pair<class_1297, class_243>>)Either.left((Object)vec));
            }
            UUID uuid = ctag.method_25926(TAG_TARGET_UUID);
            String name = ctag.method_10558(TAG_TARGET_NAME);
            return new GateIota(new Payload(index, (Either<class_243, EntityAnchor>)Either.right((Object)new EntityAnchor(uuid, name, vec))));
        }

        public GateIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return this.deserialize(tag);
        }

        public class_2561 display(class_2520 tag) {
            if (!(tag instanceof class_2497) && !(tag instanceof class_2487)) {
                return class_2561.method_43471((String)"hexcasting.spelldata.unknown");
            }
            GateIota gate = this.deserialize(tag);
            if (gate.isDrifting()) {
                return class_2561.method_43469((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).method_27692(class_124.field_1076);
            }
            return (class_2561)gate.getTarget().map(vec3 -> class_2561.method_43469((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).method_27693(String.format(" (%.2f, %.2f, %.2f)", vec3.field_1352, vec3.field_1351, vec3.field_1350)).method_27692(class_124.field_1076), entityAnchor -> {
                String offsetStr = String.format("%.2f, %.2f, %.2f", entityAnchor.offset.field_1352, entityAnchor.offset.field_1351, entityAnchor.offset.field_1350);
                String anchorStr = String.format(" (%s, %s)", entityAnchor.name, offsetStr);
                return class_2561.method_43469((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).method_27693(anchorStr).method_27692(class_124.field_1076);
            });
        }

        public int color() {
            return -43521;
        }
    };

    public GateIota(int index, @Nullable Either<class_243, Pair<class_1297, class_243>> target) {
        super(HexalIotaTypes.GATE, (Object)new Payload(index, target == null ? null : target.mapRight(pair -> new EntityAnchor(((class_1297)pair.getFirst()).method_5667(), ((class_1297)pair.getFirst()).method_5477().getString(), (class_243)pair.getSecond()))));
    }

    private GateIota(Payload payload) {
        super(HexalIotaTypes.GATE, (Object)payload);
    }

    public int getGateIndex() {
        return ((Payload)this.payload).index;
    }

    @Nullable
    public Either<class_243, EntityAnchor> getTarget() {
        return ((Payload)this.payload).target;
    }

    @Nullable
    public class_243 getTargetPos(class_3218 level) {
        Either<class_243, EntityAnchor> target = this.getTarget();
        if (target == null) {
            return null;
        }
        return (class_243)target.map(vec3 -> vec3, entityAnchor -> {
            class_1297 entity = level.method_14190(entityAnchor.uuid);
            if (entity == null) {
                return null;
            }
            return entity.method_19538().method_1019(entityAnchor.offset);
        });
    }

    public boolean isDrifting() {
        return this.getTarget() == null;
    }

    public boolean isLocationAnchored() {
        Either<class_243, EntityAnchor> target = this.getTarget();
        return target != null && target.left().isPresent();
    }

    public boolean isEntityAnchored() {
        Either<class_243, EntityAnchor> target = this.getTarget();
        return target != null && target.right().isPresent();
    }

    public Set<class_1297> getMarked(class_3218 level) {
        Set marked = GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet());
        HashSet<class_1297> out = new HashSet<class_1297>();
        for (UUID mark : marked) {
            class_1297 markEntity = level.method_14190(mark);
            if (markEntity == null) continue;
            out.add(markEntity);
        }
        return out;
    }

    public boolean isMarked(class_1297 entity) {
        Set marked = GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet());
        return marked.contains(entity.method_5667());
    }

    public int getNumMarked() {
        return ((Set)GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet())).size();
    }

    public void mark(class_1297 entity) {
        GateManager.mark(this.getGateIndex(), entity);
    }

    public void unmark(@NotNull class_1297 entity) {
        GateManager.unmark(this.getGateIndex(), entity);
    }

    public void clearMarked() {
        GateManager.clearMarked(this.getGateIndex());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (!GateIota.typesMatch((Iota)this, (Iota)that)) return false;
        if (!(that instanceof GateIota)) return false;
        GateIota gthat = (GateIota)that;
        if (this.getGateIndex() != gthat.getGateIndex()) return false;
        return true;
    }

    public boolean isTruthy() {
        return true;
    }

    @NotNull
    public class_2520 serialize() {
        class_2487 tag = new class_2487();
        tag.method_10569(TAG_INDEX, this.getGateIndex());
        if (this.getTarget() == null) {
            tag.method_10567(TAG_TARGET_TYPE, (byte)0);
        } else {
            tag.method_10567(TAG_TARGET_TYPE, ((Integer)this.getTarget().map(vec3 -> 1, pair -> 2)).byteValue());
            tag.method_10549(TAG_TARGET_X, ((Double)this.getTarget().map(vec3 -> vec3.field_1352, entityAnchor -> entityAnchor.offset.field_1352)).doubleValue());
            tag.method_10549(TAG_TARGET_Y, ((Double)this.getTarget().map(vec3 -> vec3.field_1351, entityAnchor -> entityAnchor.offset.field_1351)).doubleValue());
            tag.method_10549(TAG_TARGET_Z, ((Double)this.getTarget().map(vec3 -> vec3.field_1350, entityAnchor -> entityAnchor.offset.field_1350)).doubleValue());
            this.getTarget().ifRight(entityAnchor -> {
                tag.method_25927(TAG_TARGET_UUID, entityAnchor.uuid);
                tag.method_10582(TAG_TARGET_NAME, entityAnchor.name);
            });
        }
        return tag;
    }

    private record Payload(int index, Either<class_243, EntityAnchor> target) {
    }

    public record EntityAnchor(UUID uuid, String name, class_243 offset) {
    }
}

